package com.paytend.api.service;

import cn.hutool.json.JSONUtil;
import cn.hutool.log.Log;
import cn.hutool.log.LogFactory;
import com.paytend.api.utils.AESUtils;
import com.paytend.api.utils.PaytendUtil;
import com.paytend.api.utils.RSAUtils;


import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;


/**
 * 接口demo paytend-api v2 版本
 *
 * @author wanghui
 */
public class WaveService {

    private static final String PAYTEND_BASE_URL = "http://localhost:8080";
    private static final String PAYTEND_PUBLIC_KEY = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAt/u/mZQZcLDiUbsOTrZtS6aeeLT/UA0kZq9yXT/rPoN6zhrrpbW2Xws6eNwCY8gcemAgvqU6nXJ/KewQXh0yTCuw0ud43wJ6CwWmmqhOnLyh8xclYUSiNz5yvcMSijgWPsa1qoE8bBgVi+nbDqQYO1kJsNLuQ0+5PyetDOv2jdH6dZZi6vYJUtCSpJTLPA0vQM+e2lx22E378fjshsiOw1EclvEo9oxOTQw7XRHb7jVqwAiYsn3c3fY0oefdlF4lgOUrrLWIXdO4xhGOFEZ/HF+t+kGTWQdR/XOLCQRzWvdXqMRFPLPyWiERCaaa2YUMxfXD8zeIVGaZr4g2E53O2QIDAQAB";
    private static final String PARTNER_ID = "188001000000085";
    private static final String PARTNER_PRIVATE_KEY = "MIICdwIBADANBgkqhkiG9w0BAQEFAASCAmEwggJdAgEAAoGBAJ51bxb7N/WeL65i7eVUE0Yg+EFUiUrLiGemND1UlCVYGkGh9wPsr6VsfRQeegm+t5kZvhNqMq5lVIkl5HmratRUTCVmtNCKZaM3jOoxXmsGUHPTqbFIxHPkHeKWxfVxxyChA6V7+X0MJKqcuDoOkWZCaoxWtO5i/tKvbY9l/YOhAgMBAAECgYEAmqXv8pThy3REAsUIeq2wVdwtjc0MZRP5H3dlOooGP+AZV/7Tjl/8GM2l0PHhlwssMl6eVGJr7ip085kov9odWm18ICuYni3d0SWtohMC1ZdlELNyOHX2zSVfvv2vRR5sGwFuubeW4Fn0wzn1cgFStCgv1O3TaYooUuAoAKkgzTECQQDJiXktB/hpmT7nRBMeOgq2ldepvHkCzvM7HdCe4XeLMa/QMvvW9kuv3n7l7hAJqWwvVFSKOwU9nY/ruI/bJ3RNAkEAyUfDY3YjytN2z5dK/adC9exwo6MaX9Nhn+IWIhXQjF4tY3EHHcSG4JH8/JXmgs3VwsgqeuCLNulBavEA5gzGpQJAJ1TS9zzU+BbWNeANMxr0uElp+1Ay9Z9ZzLG24yrxX5Lk0ucASyVqA/qSHWFmc9xCpsH4dbmq/ilfywsL2CNNCQJBAMcb5F65eUKk2P0VzqsJEKYxlGNrbyWn9wSwI/Dn33tblk6uermptTrlb3t11adDctfSJqOTCGPzbjEZ4yevL7kCQHzgXvHk1YIchcj2+TJe5bzagJFvKGHj0xlxbcbmG3r9dyvkAK9os3Tq3wEAfe7VCuKGcPrNdeMRG/eC/+oTfxM=";
    private static final String VERSION = "2.0";
    private static final String SIGN_TYPE = "RSA";

    /**
     * @param
     */
    public static void main(String[] args) throws Exception {
        webPayment(
                "312006000003933"
                , ""
                , ""
                , ""
                , "861863064321633"
                , 10
                , "nini"
                , 110
                , "EUR"
                , "t22111806273615129"
                , "chongzhi"
                , "123.111.111.212"
                , "BEIJING"
                , ""
                , ""
                , ""
                , ""
                , ""
                , ""
                , ""
        );

    }


    /**
     * 日志类
     */
    public static Log logger = LogFactory.get();

    /**
     * 刷卡支付接口
     *
     * @return boolean 是否成功
     */
    public static void webPayment(String merchantId, String cardAsn, String validity, String cvv, String mobile, int cardType, String nameOnCard, long amount,
                                  String currency, String billNo, String remark, String ip, String billingAddress, String email, String websiteId, String billingCountry, String billingCity, String billingPostCode
            , String firstName, String lastName) throws Exception {
        /**
         * 组装参数
         */
        // 创建一个新的HashMap
        Map<String, Object> bizData = new HashMap<>();

        // 添加参数
        bizData.put("merchantId", merchantId);
        bizData.put("cardAsn", cardAsn);
        bizData.put("validity", validity);
        bizData.put("cvv", cvv);
        bizData.put("mobile", mobile);
        bizData.put("cardType", cardType);  // 假设cardType是int类型
        bizData.put("nameOnCard", nameOnCard);
        bizData.put("amount", amount);  // 假设amount是long类型
        bizData.put("currency", currency);
        bizData.put("billNo", billNo);
        bizData.put("remark", remark);
        bizData.put("ip", ip);
        bizData.put("billingAddress", billingAddress);
        bizData.put("email", email);
        bizData.put("websiteId", websiteId);
        bizData.put("billingCountry", billingCountry);
        bizData.put("billingCity", billingCity);
        bizData.put("billingPostCode", billingPostCode);
        bizData.put("firstName", firstName);
        bizData.put("lastName", lastName);

        String requestStr = initCommonRequest(JSONUtil.toJsonStr(bizData),true);
        /**
         * 发送请求
         */
        logger.debug("REQUEST:{}", JSONUtil.toJsonPrettyStr(requestStr));
        String responseStr = PaytendUtil.postJson(PAYTEND_BASE_URL + "/wave/pay/webPayment", requestStr);
        logger.debug("RESPONSE:{}", JSONUtil.toJsonPrettyStr(responseStr));

    }


    /**
     * 订单查询接口
     *
     * @return boolean 是否成功
     */
    public static boolean orderQuery(String merchantId, String billNo) throws Exception {
        // 创建一个新的HashMap
        Map<String, Object> bizData = new HashMap<>();
        bizData.put("merchantId", merchantId);
        bizData.put("billNo", billNo);
        String requestStr = initCommonRequest(JSONUtil.toJsonStr(bizData),true);
        logger.debug("REQUEST:{}", JSONUtil.toJsonPrettyStr(requestStr));
        String responseStr = PaytendUtil.postJson(PAYTEND_BASE_URL + "/wave/pay/queryOrder", requestStr);
        logger.debug("RESPONSE:{}", JSONUtil.toJsonPrettyStr(responseStr));
        return true;
    }


    /**
     * 退款接口
     *
     * @return boolean 是否成功
     */
    public static boolean refund(String merchantId, String billNo) throws Exception {
        Map<String, Object> bizData = new HashMap<>();
        bizData.put("merchantId", merchantId);
        bizData.put("billNo", billNo);
        String requestStr = initCommonRequest(JSONUtil.toJsonStr(bizData),true);
        logger.debug("REQUEST:{}", JSONUtil.toJsonPrettyStr(requestStr));
        String responseStr = PaytendUtil.postJson(PAYTEND_BASE_URL + "/wave/pay/refund", requestStr);
        logger.debug("RESPONSE:{}", JSONUtil.toJsonPrettyStr(responseStr));
        return true;
    }

    /**
     * 初始化 公共请求信息
     *
     * @return
     */
    public static String initCommonRequest(String requestStr, boolean isAES) throws Exception {
        String aesKey = AESUtils.generateKey();

        Map<String, Object> commonRequestMap = new HashMap<>();

        commonRequestMap.put("requestId", PaytendUtil.genOutTradeNo());
        commonRequestMap.put("partnerId", PARTNER_ID);
        commonRequestMap.put("version", VERSION);
        commonRequestMap.put("signType", SIGN_TYPE);
        commonRequestMap.put("bizData", requestStr);
        commonRequestMap.put("randomKey", aesKey);
        String signDataString = getTreeValue(commonRequestMap,false);
        System.out.println("signDataString:" + signDataString);
        commonRequestMap.put("signature", RSAUtils.sign(signDataString.getBytes("UTF-8"),PARTNER_PRIVATE_KEY));

        commonRequestMap.put("bizData", isAES == true ? AESUtils.encrypt(requestStr, aesKey) : JSONUtil.parseObj(requestStr));
        commonRequestMap.put("randomKey", RSAUtils.encryptPublicKey(aesKey, PAYTEND_PUBLIC_KEY));
        return JSONUtil.toJsonStr(commonRequestMap);
    }

    public static String getTreeValue(Map<String, Object> toSortData, boolean emptyParamIsSign) {
        TreeMap<String, Object> params = new TreeMap<String, Object>();
        params.putAll(toSortData);
        StringBuffer orgin = new StringBuffer();
        Iterator<String> iter = params.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String) iter.next();
            String value = String.valueOf(params.get(key));
            if (emptyParamIsSign) {//空值参数参与签名
                orgin.append("&").append(key).append("=").append(value);
            } else {//空值参数不参与签名
                if (value != null && value != "") {
                    orgin.append("&").append(key).append("=").append(value);
                }
            }
        }
        return orgin.toString().substring(1);
    }
}
