const sessionId = Date.now().toString() + Math.floor(Math.random() * 10000).toString();
const merchantId = "312006000180716";

const testUrl = "https://test-api-ppay.paytend.com/api/paymentiframe.htm";
const prodUrl = "https://api-ppay.paytend.com/api/paymentiframe.htm";

PPayFrame.init(sessionId, merchantId, testUrl);

// Add a custom event listener for payment success
PPayFrame.addEventListener('paymentSuccess', (data) => {
  console.log('Custom Event: Payment was successful!', data);
  alert('Payment was successful!');
});

// Add a custom event listener for payment failure
PPayFrame.addEventListener('paymentFailed', (data) => {
  console.log('Custom Event: Payment failed.', data);
  alert('Payment failed. Please try again.');
});

// Add a custom event listener for payment error
PPayFrame.addEventListener('paymentError', (error) => {
  console.log('Custom Event: There was an error with the payment.', error);
  alert('There was an error processing your payment. Please try again later.');
});
